![image](teaser.png)

# 1.4.1

This update focuses on improving stability and usability, as well as expanding the list of supported hardware. The new version enhances firmware installation and update processes, includes interface adjustments, and fixes several bugs for a more comfortable user experience.

### New Features:

- **Extended Bitmain Diagnostics:** Hashcore Toolkit can now detect error states for Bitmain firmware, providing more comprehensive insights into your hardware's operation.
- **Improved Firmware Error Handling:** Firmware install/update dialogs are now more informative thanks to enhanced error handling and directory availability notifications.
- **ePIC Firmware Support:** Introducing support for firmware on ePIC hardware, expanding your mining management capabilities.

### Improved

- **Intuitive Pool Editing:** Improved visual feedback while editing pools – validation errors are now reset more clearly, and unchanged fields are highlighted in a different color.
- **More Convenient Autoscan Controls:** Autoscan controls for groups on the main screen are now easier to use.
- **Interface Enhancements:** Updated network group selection behavior and added a pool edit button in the device info dialog.
- **Internal Optimization:** Updated installation scripts for various platforms (aml, bb, xil), and improved default settings with configuration migration support.

### Fixed

- **Stable Task History:** Resolved issues with task history filtering and deletion.
- **Accurate Device Status Display:** Fixed status hover freeze when mousing over a device.
- **Reliable Firmware Installation:** Fixed firmware install issues on older xil-platform devices.
- **Visible Device List Scrolling:** Fixed the “scroll to top” button not appearing in the device list.
- **Precise Antminer L9 Support:** Adjusted supported platform list for Antminer L9.
- **Preset Center & UI Improvements:** Numerous fixes and enhancements across the interface and Preset Center, including display fixes, helpful tooltips, and smoother filter/preset usage.

**We recommend updating Hashcore Toolkit to version 1.4.1 for better stability and overall experience.**

Thank you for being with us!

### 1.4.0

- Device dashboard.
- Automatic group statistics update.
- Informative tooltips during firmware operations.
- Group operations for network groups.
- Network group merging.
- Automatic opening of the first group on launch.
- Convenient data copying via new floating button.
- Quick IP range addition.
- Hotkeys for navigation and statistics updates in group lists and views (CTRL/CMD+R).
- Diagnostic report saving.
- CLI improvements: Added `switch-pool`, `restore-cv`, `export`; fixed error messages.
- New column: "Firmware Build Time".
- Extended cloning support.
- Auradine firmware support (data, unlock, restart, reboot).
- New welcome screen animation and visuals.
- Linux_arm builder for Raspberry Pi support.
- Added descriptions for menu commands.
- Changed group context menu appearance/position.
- Device menu shows only supported commands.
- Autoscan toggle on network group screen.
- Error display (gray screen).
- Group menu in list.
- Network group display.
- Automatic stats update start.
- Redesigned confirmation dialogs.
- Config fetch from stock S21+ firmware.
- First Windows launch after update.
- Filtering menu crash fix.
- Status bar behavior (Android).
- File saving fix (Android).
- Group reordering bug with open tooltip.
- Delayed settings saving fix.
- Firmware install script for xil devices.
- App freeze on device data fetch fix.
- Legacy firmware compatibility for /info.
- UI performance during active scanning.

### 1.3.4

- Resolved a compatibility issue with older firmware versions (device data retrieval `/info`), ensuring more stable operation across a wider range of hardware.
- Added support for cloning "Minimum Number of Working Chains" and "Ignore Temperature Sensors on Chips" settings, enabling more granular device configuration.
- Added support for Antminer L9, S21+, S21+ Hydro, and S19 pro hydro 120, broadening the management capabilities for modern hardware.

### 1.3.3

- Added filters for pool account and cooling mode, as well as grouping by pool account. This will allow you to manage devices more flexibly and analyze their performance.
- Now, firmware installation and updates will be even simpler and clearer thanks to the added tooltips.
- Added the ability to specify a list of addresses for executing commands using a file, simplifying the management of a large number of devices.
- Changed the device isolation logic and moved filter generation to a separate isolate to improve interface performance.
- In the settings cloning dialog, the "Maximum Mining Start Delay" field has been added, and the "Cooling Mode" and "Target Temperature" ("Fan Speed") settings have been merged to avoid conflicts.
- Fixed the "firmware version too new" message during installation.
- Fixed the issue of list modifiers not applying after changing groups via the context menu.
- In the settings dialog, fixed theme localization when changing the language.
- Fixed the firmware check for the stock miner during firmware installation.
- Fixed the artifact when opening the device menu.
- Fixed the artifact when opening a network group with no enabled ranges.

### 1.3.2

- We've added **`Device Serial Number`** and **`Current hashrate`** columns so you can quickly access essential information about your devices and analyze their performance more effectively
- We have improved drag & drop functionality, fixed the position of the selection control buttons in the device export list, and added a way to control the application's zoom level.
- We have fixed a number of bugs that could cause problems when working with the program, including an issue where devices were mixed up in the list when changing groups during a scan. We also fixed the issue with changing the pool template from the pool editing dialog and the values of cloned settings in the cloning dialog.
- Fixed the localization of cloned settings and corrected typos in several places.
- We have updated the application's framework and dependencies to ensure more stable and efficient operation of Hashcore Toolkit.
- Fixed the freezing of the context menu and other minor UI fixes.

We strived to make this release as useful as possible for you, paying special attention to stability and usability. We hope you enjoy the new features and improvements

### 1.3.1

- Fixed dialogue, editing of pools
- Fixed device list update issue when changing groups during scanning

### 1.3.0

- New "Monitoring" Display Mode Easily monitor the status of your devices with a heatmap, allowing you to quickly identify and resolve potential issues.
- Group Subnet Editing Edit subnets within the network group editing dialog.
- Device Search Search for devices by IP and MAC addresses, as well as pool addresses and workers.
- Pool Presets Save pools as templates for quick application and switching.
- Cloning Clone pools, settings for stopping mining in case of chain malfunction, maximum fan speed, and minimum preset.
- Template Center Manage and create pool and filter presets in one central location.
- New View and Command Control Panel Switch between views, search for devices, and perform bulk operations.
- Diagnostic Report Export Export reports for VNISH firmware, both for individual devices and groups.
- MAC Address Export Export device MAC addresses when exporting lists.
- New Keyboard Shortcuts Ctrl/Cmd + F to search for devices and Ctrl/Cmd + A to select all items in the list.
- Braiins Firmware Power Consumption Braiins firmware now displays power consumption information.
- Network Scanning Start and stop scanning as needed.
- Reset Firmware and Remove Firmware Function Descriptions Added brief descriptions to the device menu.
- Improved Operations Section Problematic operations will no longer go unnoticed.
- Simplified Firmware Installation/Update Dialog Installing firmware is now even easier.
- Miner Error Descriptions Hover over the error status to see its cause.
- Modified Temperature Export Export chip and board temperatures separately for each board.
- Consistent Hashrate Values in Monitoring Mode Hashrate values in the monitoring mode are now standardized.
- Filter List Updates Dynamically The filter list now updates as the device list changes.
- Optimized Interface Updates During Network Scanning Improved UI performance during network scanning.
- Modified Group Statistics Calculation Group statistics are now displayed in the group switching menu.
- Expanded Variable Templates in Pools Added the `{ip}` template, parameters in templates, delimiter editing in `{ip:}, {mac:}`, and control over the first value and step in `{n:}, {nn:}, {nnn:}`.
- Grouped Fields in Sort and Filter Menus Fields in the sorting and filtering menus are now grouped for better organization.
- Modified Stock Firmware Version Display for Bitmain Devices The display of stock firmware versions for Bitmain devices has been updated.
- Modified Group Statistics Layout Adjusted the width of grouping fields.
- Display of minimum preset
- Interface Improvements Increased the width of the firmware version column, modified the appearance of tooltips, and improved the list display in pool mode.
- "Remove Firmware" Task: The "Remove Firmware" task is now correctly disabled for VNISH firmware installed on SD cards.
- Model Detection for S19j Pro-A and S19 Pro-A: Improved model detection for S19j Pro-A and S19 Pro-A devices during firmware installation.
- Display of Fan Speed and Chain Status: Fixed the display of fan speed and chain status when empty data is received.
- Canceling Scan After Opening Second Network Group: Fixed an issue where scanning would not properly cancel after opening a second network group.
- Deselecting Devices in Compact Mode: Fixed an issue with deselecting devices in compact mode.
- Updating Network Group Statistics After Rescanning: Fixed the updating of network group statistics after rescanning addresses.
- Selected Settings Counter for Cloning: Fixed the counter for selected settings when cloning.
- Input Validation in Pool Editing Dialog: Fixed input validation in the pool editing dialog.
- Applied Filter Value Error: Fixed an error with applied filter values.
- Numerous Other Minor Bug Fixes and Improvements.

### 1.2.0
- Device grouping and statistics
- Notifications about new versions
- Added custom device display mode
- Support for Antminer S21 XP Hydro and Antminer S21XP Imm
- Implemented the "Find miner" command for Bitmain firmware (Antminer Stock)
- Statistics for Braiins and Luxor firmware
- Display of DevFee and issue warnings
- Chinese localization
- Display of firmware build name
- Added "About" section
- Introduced new commands in `toolkit_cli` (clone and reset-autotune)
- Group import via drag & drop
- Optimized adding devices during network scanning
- Enhanced worker sorting
- Fully redesigned firmware installation
- UI improvements: increased firmware version column width, redesigned tooltips, and improved list display in pool mode
- Quick access to range group export
- Export of a single group from the network group's context menu
- Fixed Windows freeze on startup when window position data is lost
- Fixed data loss in the application (restoration file saving)
- Resolved thread blocking when running handlers written in Rust
- Changed the behavior of the Rescan button in the device list
- Fixed toolkit_cli operation
- Fixed the execution of the "Install Firmware" task
- Corrected labels for controls and app descriptions on Mac
- Fixed task cancellation (scanning, firmware restoration, etc.) when exiting a network group

### 1.1.0
- Presets for filters and sorting
- Added device filtering and sorting by subnets
- Added firmware reset operation
- Support for Antminer S19j XP and S19e XP Hydro
- Device "Offline" display mode
- Russian language localization
- Multi-level menu headers
- Labels for unlock types
- Responsiveness: Added some responsiveness to the application for small device screens
- Operations window: extended information, filtering, deleting, stopping operations
- Device context menu
- Search and monitoring algorithms
- Warnings and labels for unlock types
- Device cloning feature
- Application interface
- Improved filter selection
- Quick access to device list export
- Fixed issue with canceling user passwords
- Fixed automatic removal of spaces in firmware file names
- Fixed error exporting and importing network groups for Windows
- Ended support for Windows 8 and older versions

### 1.0.2
- Fixed an issue that caused the launch to fail on Windows 11

### 1.0.1
- Fixed timeout issue when saving the network list
- Minor interface adjustments
- Added data validation in the Firmware Installation and Firmware Update dialogs (checks for empty firmware name and version)
- Added group power consumption
- Updated file name generation for exporting files. The imported file name is now used as the group name
- Implemented password saving for a range in the unlock dialog for a single miner
- Fixed issue with ignoring model parameters during firmware updates
- Fixed pool mode artifact
- Windows 7 and 8 support will be discontinued in future versions

### 1.0.0
- Initial release of the application