![image](teaser.png)

# 1.5.0

HashCore Toolkit 1.5.0 — a major update with over 100 improvements for professional mining farm management.  
This release introduces advanced Bitmain device control, new monitoring columns for energy efficiency and temperatures, improved list performance, support for WhatsMiner 60 series and Antminer S19 XP Plus Hydro, and automatic updates for desktop versions.  
Memory management and network scanning speed are significantly optimized, and critical firmware installation bugs have been fixed.

## New Features

#### Device Management

- **Password Change on Bitmain Firmware** – full security control over your devices
- **Bitmain Firmware Reset** – restore factory settings with one command
- **Stock Device Operation Modes** – pause and resume mining without rebooting
- **Autotune Profile Reset** – quickly return to optimal settings

#### Monitoring & Reporting

- **"Energy Efficiency" Column** – instant evaluation of device efficiency with power and hashrate data
- **"Error Code" Column** – quick diagnostics directly in the device list
- **Power Supply Temperatures** – new columns for PSU temperature monitoring
- **Profile Temperature Thresholds** – track critical temperature limits
- **Mining Algorithm Display** – new column with filtering and grouping by algorithm (SHA-256, Scrypt)
- **Firmware Publisher Display** – see the software source directly in the device list

#### Filtering & Search

- **Filter by Number of Boards with Errors** – quickly find problematic devices
- **Filter by Board Status** – detailed filtering by individual board condition
- **Search in Network Groups** – instant access to the right group
- **Invert Selection** – quickly switch selected devices

#### Data Management

- **Copy IP Addresses** – easily copy device IPs
- **Import IP Lists** – automatically compress consecutive IPs into ranges
- **IP-report Processing** – support for device reports in the network

#### Advanced Settings

- **Clone Additional Parameters**:
    - Auto-retune on chain failure
    - Allow disabling chains without PIC
    - Offline mining
    - Allowable power increase
    - Global voltage
    - Global frequency
- **Template Creation by Copying** – quickly create similar configurations
- **Default Templates** – in pool edit dialog

#### Group Operations

- **Chunk Splitting** – manage load during mass operations on thousands of devices

#### Platforms & Updates

- **Windows Installer** – simplified installation
- **Automatic Update** – for all desktop versions
- **Pull-to-refresh on Android** – update the list with a swipe
- **Support for WhatsMiner 60 series** – extended compatibility with the latest devices
- **Support for Antminer S19 XP Plus Hydro** – full water-cooling support

#### CLI Extensions

- **`version` Command** – check version via command line
- **`find` Command** – search for devices through CLI

#### Interface

- **Exit Confirmation** – prevents accidental closure (Windows, Linux)
- **Confirm Dialogs with Enter Key** – faster workflow
- **Linux Taskbar Icon** – native system integration
- **Quick Power Management Commands** – added to the command panel

---

## Improvements

#### Performance

- **Significant Speed Improvements** in the device list
- **Reduced Memory Usage** – optimized for large farms
- **Enhanced Device Discovery Algorithms** – faster and more accurate scanning
- **Eliminated Scan Delay** caused by unresponsive addresses
- **Optimized Redraw** of the device name column in compact mode

#### Interface & UX

- **Updated Device Status Display** – new logic for showing status time
- **Improved Sorting by Status** – more logical prioritization
- **Enhanced Device Selection Behavior** – smoother interactions
- **Adjusted Cell Sizes** – improved readability in the device list
- **Refined Row Layout** – cleaner list presentation
- **Tooltips for Headers** – now available in compact mode
- **Expanded Click Area** – easier access to device info panel
- **Auto-hide “Scroll to Top” Button** – when the list has no scroll
- **Delayed Copy Button Appearance** – prevents accidental clicks
- **Updated Text Styles** – better readability

#### Status Handling

- **Reworked Bitmain Firmware Status Display**
- **Restored Status Description** when hovering over a device
- **Improved Status Time Display** (configurable on/off)
- **Tooltip Now Includes Status Name**
- **Revised Device Status Grouping**

#### Temperature Handling

- **Correct Chip Temperature Display** instead of board temperature for MicroBT
- **Proper Temperature Display** for Hashcore devices in Failure state
- **Fixed Temperature Display** for disabled boards

#### Data Handling

- **Changed “Uptime” Calculation** for Vnish/Hashcore firmware
- **Firmware Release Date Parsing** for Bitmain (FR-series)
- **Improved Device Data Display** for Hashcore/Vnish during Restarting
- **Fixed “Cooling” Field** in CSV export
- **Updated Cooling Info Structure** – new column format

#### Dialogs & Forms

- **Reworked Update Dialog** – more informative interface
- **Improved Pool Edit Dialog**:
    - Removed placeholders from input fields
    - Added password templates for group edit
    - Fixed “Clear” button behavior
- **Limited Preset Description Length** – prevents overflow

#### Network Groups

- **Subnet Count** added to the device list and edit dialog
- **Current Group Highlighted** in group change menu
- **Case-Insensitive Search** in network groups

#### Technical

- **Updated Framework and Dependencies** – improved stability
- **Modified MicroBT Firmware Handling** – using new API
- **Improved Canaan (Avalon) Firmware Support** – CG Miner protocol for access issues
- **Changed Configuration Update Request** for stock Antminers
- **Optimized Firmware Installation Scripts** on AML (UBI2 prevention)
- **Enhanced Update Scripts** for macOS and Windows
- **Added File Integrity Check** for the application

---

## Fixes

#### Critical Fixes

- **Fixed Timeout Error** during firmware installation
- **Resolved Firmware Installation Issues** for Hashcore on AML devices
- **Fixed Firmware Recovery Timeout** on CVITEK platform
- **Fixed Windows Launch Issue** when files were corrupted
- **Eliminated Infinite Processing** of unsupported file formats

#### Data Display

- **Fixed Cooling Parameter Display** for firmware 1.2.6
- **Correct Hashrate Reading** for MicroBT with 4 boards
- **Firmware Support Fixed**:
    - Vnish 1.1.12
    - Canaan (Avalon)
    - MicroBT via HTTP API
- **Removed “Error” Coolers** from exported data
- **Fixed CSV Encoding** on Windows – correct headers

#### Interface

- **Fixed Header Flickering** in compact mode when adding columns
- **Fixed Scrollbar Hiding** on display mode change
- **Eliminated UI Flicker** on inactive tabs when changing Action Bar
- **Fixed Horizontal Scrollbar Behavior**
- **Proper Device List Layout** for better scroll performance
- **Fixed Text Overflow** in template selection menu
- **Correct Empty Fields Display** in IP range
- **Fixed “Cooling” Column Width**
- **Fixed Window Border Width** on Windows

#### Functionality

- **Fixed Grouping** by device status
- **Correct Device Selection** on CheckBox click
- **Fixed Header Redraw** after device renaming
- **Restored Sorting** after switching group via dropdown
- **Fixed Offline Transition** when canceling scan
- **Fixed Rescan Interruption** triggered by user
- **Correct Delay** in applying global settings

#### Hotkeys & Interaction

- **Fixed CTRL/CMD+A Usage** in search field
- **Correct “Show Status Time” Toggle Behavior**
- **Fixed “Unlock” Button Behavior** when lock status changes

#### Updates & Security

- **Fixed Update Algorithm** for Windows
- **Correct Update Scripts** for macOS and Windows
- **Blocked Unauthorized Tasks** on locked devices

#### Autoscan

- **Fixed Autoscan Settings Reset** after editing a group
- **Proper Autoscan Launch** when entering/leaving a network group

#### Statistics & Notifications

- **Fixed Stats Update** after device unlock
- **Correct Notification Type Detection** for failed tasks
- **Fixed Notification Position** – no longer covers dialogs
- **Adjusted “Dead Zone”** around task completion notifications  
